/*******************************************************************************
*                         USB4ALLAPI Library Version 1.0                       *
********************************************************************************
* FileName: CommandLayer.cpp                                                   *
*                                                                              *
* Author                     Date           Version                            *
*------------------------------------------------------------------------------*
* Carlos Grossy              21/03/2007       1.0                              *
* Carlos Grossy              05/04/2007       1.1                              *
* Carlos Grossy              17/05/2007       1.2                              *
*******************************************************************************/

#include "CommandLayer.h"

commandLayer::commandLayer(handlerLayer *hanlay) {

    l = log::instance();
    cp = new commandPackage();
    hl = hanlay;
}

commandLayer::~commandLayer() {

    l->printLog("commandLayer Destructor",true,true);
    delete cp;
    l = NULL;
    hl = NULL;
}

handler commandLayer::open(int serial, char *disp, usbin dscin, usbout dscout) {

    commPackage *cpack;
    char *msg, *res;
    int nlen, epin, epout, id;
    bool ok;

    if (dscin != NULL_IN) {
        epin = hl->requestDscIn(serial, dscin);
    }
    else {
        epin = 0;
    };
    if (dscout != NULL_OUT) {
        epout = hl->requestDscOut(serial, dscout);
    }
    else {
        epout = 0;
    };
    if ((epin != 255) && (epout != 255)) { // Sacar los 255 por literales
        cpack = new commPackage();
        cpack->tc = OPEN;
        cpack->disp = new char[strlen(disp)];
        strcpy(cpack->disp,disp);
        cpack->usbin = epin;
        cpack->usbout = epout;
    }
    else {
        return HNDERROR;
    };

    msg = cp->buildPackage(cpack, nlen);
    delete cpack;

    id = hl->buildDeviceId(serial, U4AHND);

    if (hl->send(id, msg, nlen, DELAYSEND)) {
        res = hl->receive(id, ok, nlen, DELAYRECV);
        if (ok) {
            cpack = cp->unbuildPackage(res,nlen);
            if (cpack->h != HNDERROR) {
                id = hl->buildDeviceId(serial,cpack->h);
                hl->addEntry(id, epin, epout); // Inicializa los buffers para los endpoints indicados.
            }
            else {
                l->printLog("A error ocurred when the device was opened.",true,true);
                id = HNDERROR;
            };
            delete cpack;
            return id;
        }
    }
    return HNDERROR;
}

bool commandLayer::close(int id) {

    commPackage *cpack;
    int nlen, serial, hnd, idbase;
    char *msg, *res;
    bool ok;

    if (hl->existsEntry(id)) {

        hnd = hl->unBuildDscPart(id);
        serial = hl->unBuildSerialPart(id);

        cpack = new commPackage();
        cpack->tc = CLOSE;
        cpack->hnd = hnd;
        msg = cp->buildPackage(cpack, nlen);
        delete cpack;

        idbase = hl->buildDeviceId(serial, U4AHND);

        if (hl->send(idbase,msg,nlen,DELAYSEND)) {
            res = hl->receive(idbase, ok, nlen,DELAYRECV);
            if (ok) {
                cpack = cp->unbuildPackage(res,nlen);
                if (cpack->res == 1) {
                    ok = true;
                    hl->removeEntry(id); // se saca de la tabla el handler.
                }
                else {
                    ok = false;
                };
                delete cpack;
                return ok;
            };
        };
    };
    return false;
}
